SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

CREATE SCHEMA IF NOT EXISTS `entrepotIsima` DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci ;
USE `entrepotIsima` ;

-- -----------------------------------------------------
-- Table `entrepotIsima`.`d_provenance`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `entrepotIsima`.`d_provenance` ;

CREATE  TABLE IF NOT EXISTS `entrepotIsima`.`d_provenance` (
  `provenance` VARCHAR(64) NOT NULL ,
  `typeProvenance` VARCHAR(32) NULL ,
  `niveauBac` VARCHAR(32) NULL ,
  PRIMARY KEY (`provenance`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `entrepotIsima`.`d_bac`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `entrepotIsima`.`d_bac` ;

CREATE  TABLE IF NOT EXISTS `entrepotIsima`.`d_bac` (
  `deptBac` VARCHAR(32) NOT NULL ,
  `regionBac` VARCHAR(32) NULL ,
  `paysBac` VARCHAR(32) NULL ,
  PRIMARY KEY (`deptBac`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `entrepotIsima`.`d_nationalite`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `entrepotIsima`.`d_nationalite` ;

CREATE  TABLE IF NOT EXISTS `entrepotIsima`.`d_nationalite` (
  `nationalite` VARCHAR(64) NOT NULL ,
  `typeNationalite` VARCHAR(64) NULL ,
  PRIMARY KEY (`nationalite`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `entrepotIsima`.`d_niveau`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `entrepotIsima`.`d_niveau` ;

CREATE  TABLE IF NOT EXISTS `entrepotIsima`.`d_niveau` (
  `niveau` VARCHAR(64) NOT NULL ,
  `filiere` VARCHAR(64) NULL COMMENT 'F3, G31' ,
  `annee` VARCHAR(8) NULL COMMENT 'ZZ2, ...' ,
  PRIMARY KEY (`niveau`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `entrepotIsima`.`d_domaine`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `entrepotIsima`.`d_domaine` ;

CREATE  TABLE IF NOT EXISTS `entrepotIsima`.`d_domaine` (
  `ssdomaine` VARCHAR(64) NOT NULL COMMENT 'Reporting, Analyse numérique, ...\n' ,
  `domaine` VARCHAR(64) NULL COMMENT 'BI, Math, ...' ,
  PRIMARY KEY (`ssdomaine`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `entrepotIsima`.`d_entreprise`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `entrepotIsima`.`d_entreprise` ;

CREATE  TABLE IF NOT EXISTS `entrepotIsima`.`d_entreprise` (
  `nomEntreprise` VARCHAR(128) NOT NULL ,
  `groupeEntreprise` VARCHAR(64) NULL ,
  `domaineEntreprise` VARCHAR(128) NULL ,
  `typeEntreprise` VARCHAR(128) NULL ,
  `villeEntreprise` VARCHAR(64) NULL ,
  `depEntreprise` VARCHAR(64) NULL ,
  `regionEntreprise` VARCHAR(64) NULL ,
  `paysEntreprise` VARCHAR(64) NULL ,
  PRIMARY KEY (`nomEntreprise`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `entrepotIsima`.`faits`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `entrepotIsima`.`faits` ;

CREATE  TABLE IF NOT EXISTS `entrepotIsima`.`faits` (
  `idFait` INT NOT NULL AUTO_INCREMENT ,
  `etudiant` VARCHAR(32) NOT NULL ,
  `anneeScolaire` VARCHAR(32) NOT NULL ,
  `sexe` CHAR(1)  NULL ,
  `redoublant` VARCHAR(32) NULL DEFAULT 'Non renseigné' ,
  `statut` VARCHAR(32) NULL DEFAULT 'Non renseigné' ,
  `categorieSocioProfessionel` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `age` INT NULL ,
  `provenance` VARCHAR(32) NULL DEFAULT 'Non renseigné' ,
  `anneeBac` INT NULL ,
  `mentionBac` VARCHAR(16) NULL DEFAULT 'Non renseigné' ,
  `deptBac` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `entrepriseProjet` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `entrepriseStage` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `niveau` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `domaineProjet` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `domaineStage` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `nationalite` VARCHAR(64) NULL DEFAULT 'Non renseigné' ,
  `moyenne` FLOAT NULL ,
  `classement` FLOAT NULL ,
  INDEX `provenance` (`provenance` ASC) ,
  INDEX `deptBac` (`deptBac` ASC) ,
  PRIMARY KEY (`idFait`) ,
  INDEX `niveau` (`niveau` ASC) ,
  INDEX `domaineProjet` (`domaineProjet` ASC) ,
  INDEX `domaineStage` (`domaineStage` ASC) ,
  INDEX `entrepriseProjet` (`entrepriseProjet` ASC) ,
  INDEX `entrepriseStage` (`entrepriseStage` ASC) ,
  UNIQUE INDEX `uniqueAnneeEtudiant` (`etudiant` ASC, `anneeScolaire` ASC) ,
  CONSTRAINT `provenance`
    FOREIGN KEY (`provenance` )
    REFERENCES `entrepotIsima`.`d_provenance` (`provenance` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `deptBac`
    FOREIGN KEY (`deptBac` )
    REFERENCES `entrepotIsima`.`d_bac` (`deptBac` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `nationalite`
    FOREIGN KEY (`nationalite` )
    REFERENCES `entrepotIsima`.`d_nationalite` (`nationalite` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `niveau`
    FOREIGN KEY (`niveau` )
    REFERENCES `entrepotIsima`.`d_niveau` (`niveau` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `domaineProjet`
    FOREIGN KEY (`domaineProjet` )
    REFERENCES `entrepotIsima`.`d_domaine` (`ssdomaine` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `domaineStage`
    FOREIGN KEY (`domaineStage` )
    REFERENCES `entrepotIsima`.`d_domaine` (`ssdomaine` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `entrepriseProjet`
    FOREIGN KEY (`entrepriseProjet` )
    REFERENCES `entrepotIsima`.`d_entreprise` (`nomEntreprise` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `entrepriseStage`
    FOREIGN KEY (`entrepriseStage` )
    REFERENCES `entrepotIsima`.`d_entreprise` (`nomEntreprise` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

-- -----------------------------------------------------
-- Data for table `entrepotIsima`.`d_provenance`
-- -----------------------------------------------------
START TRANSACTION;
USE `entrepotIsima`;
INSERT INTO `entrepotIsima`.`d_provenance` (`provenance`, `typeProvenance`, `niveauBac`) VALUES ('Non renseigné', 'Non renseigné', 'Non renseigné');

COMMIT;

-- -----------------------------------------------------
-- Data for table `entrepotIsima`.`d_bac`
-- -----------------------------------------------------
START TRANSACTION;
USE `entrepotIsima`;
INSERT INTO `entrepotIsima`.`d_bac` (`deptBac`, `regionBac`, `paysBac`) VALUES ('Non renseigné', 'Non renseigné', 'Non renseigné');

COMMIT;

-- -----------------------------------------------------
-- Data for table `entrepotIsima`.`d_nationalite`
-- -----------------------------------------------------
START TRANSACTION;
USE `entrepotIsima`;
INSERT INTO `entrepotIsima`.`d_nationalite` (`nationalite`, `typeNationalite`) VALUES ('Non renseigné', 'Non renseigné');

COMMIT;

-- -----------------------------------------------------
-- Data for table `entrepotIsima`.`d_niveau`
-- -----------------------------------------------------
START TRANSACTION;
USE `entrepotIsima`;
INSERT INTO `entrepotIsima`.`d_niveau` (`niveau`, `filiere`, `annee`) VALUES ('Non renseigné', 'Non renseigné', 'Non renseigné');

COMMIT;

-- -----------------------------------------------------
-- Data for table `entrepotIsima`.`d_domaine`
-- -----------------------------------------------------
START TRANSACTION;
USE `entrepotIsima`;
INSERT INTO `entrepotIsima`.`d_domaine` (`ssdomaine`, `domaine`) VALUES ('Non renseigné', 'Non renseigné');

COMMIT;

-- -----------------------------------------------------
-- Data for table `entrepotIsima`.`d_entreprise`
-- -----------------------------------------------------
START TRANSACTION;
USE `entrepotIsima`;
INSERT INTO `entrepotIsima`.`d_entreprise` (`nomEntreprise`, `groupeEntreprise`, `domaineEntreprise`, `typeEntreprise`, `villeEntreprise`, `depEntreprise`, `regionEntreprise`, `paysEntreprise`) VALUES ('Non renseigné', 'Non renseigné', 'Non renseigné', 'Non renseigné', 'Non renseigné', 'Non renseigné', 'Non renseigné', 'Non renseigné');

COMMIT;
